#define WIN32_LEAN_AND_MEAN 
#include <Windows.h> 
#include <string> 

std::string sWindowClass = "KlasaOkna"; 

//przycisk
HINSTANCE* ghInstance; //globalna kopia uchwytu do okna
HWND hButton, ghWindow;

/* 
Events procedure 
Again... 
#define CALLBACK __stdcall 
*/
  
LRESULT CALLBACK WindowEventProc(HWND hWindow, UINT uMsg, WPARAM wParam, LPARAM lParam)
{ 
    switch(uMsg) 
    { 
    case WM_DESTROY: 
        PostQuitMessage(0); 
        break; 

	//przycisk
	case WM_CREATE:
		hButton = CreateWindowEx(
			NULL,
			"Button",
			"Witaj wiecie!",
			WS_CHILD | WS_VISIBLE,
			30, 30, 200, 70, //geometria
			hWindow,
			//GetDesktopWindow(),
			(HMENU)1,
			*ghInstance,
			NULL);
		break;
    } 
  
    return DefWindowProc(hWindow, uMsg, wParam, lParam); 
} 

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE, LPSTR, int nCmdShow) 
{ 
	//przycisk
	ghInstance = &hInstance;

    WNDCLASSEX windowClass; 
  
    ZeroMemory(&windowClass, sizeof(windowClass)); 
    windowClass.cbSize = sizeof(windowClass); 
    windowClass.hInstance = hInstance; 
    windowClass.lpfnWndProc = WindowEventProc; 
    windowClass.lpszClassName = sWindowClass.c_str(); 
    windowClass.hCursor = LoadCursor(NULL, IDC_ARROW); 
    windowClass.hIcon = LoadIcon(NULL, IDI_APPLICATION); 
    windowClass.hbrBackground = (HBRUSH) COLOR_WINDOW; 
  
    RegisterClassEx(&windowClass); 
      
    ghWindow = CreateWindowEx( 
        NULL,                    // window style 
        sWindowClass.c_str(),    // class name 
        "Nazwa okna",            // caption 
        WS_OVERLAPPEDWINDOW,    // window style 
        CW_USEDEFAULT,            // X coord 
        CW_USEDEFAULT,            // Y coord 
        CW_USEDEFAULT,            // width 
        CW_USEDEFAULT,            // height 
        NULL,                    // parent window 
        NULL,                    // menu 
        hInstance,                // app instance 
        NULL                    // additional data 
    ); 
  
    //Pokazywanie okna
    ShowWindow(ghWindow, nCmdShow); 
  
    //Petla komunukatow  
    MSG msgMessage; 
    while(GetMessage(&msgMessage, NULL, 0, 0)) 
    { 
        TranslateMessage(&msgMessage); 
        DispatchMessage(&msgMessage); 
    } 
  
    // return code 
    return static_cast<int>(msgMessage.wParam); 
} 

